<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis liniových prvků zaměření</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis liniových prvků zaměření</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="SurveyFieldbook">
                                <table class="margin" cellpadding="2" width="80%">
                                    <tbody>
                                        <tr>
                                            <th align="right"  lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Jednotky:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@surveyLinearUnits"/></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr />
                                <!-- Cogo chain Data -->
                                <table class="margin" cellpadding="2" cellspacing="2" width="80%">
                                    <thead style="display:table-header-group">
                                        <tr>
                                            <th class="underline" lang="en" align="left">Název<br/>řetězce</th>
                                            <th class="underline" lang="en" align="left">Popis</th>
                                            <th class="underline" lang="en" align="left">Definice<br/>prvku</th>
                                            <th class="underline" lang="en" align="left">Zobrazit</th>
                                            <th class="underline" lang="en" align="right">Zóna</th>
                                            <th class="underline" lang="en" align="left">Dvojice<br/>vlastnosti</th>
                                            <th class="underline" lang="en" align="left">Název<br/>datového<br/>souboru</th>
                                            <th class="underline" lang="en" align="left">Polní<br/>zápisník</th>
                                            <th class="underline" lang="en" align="left">Soubor<br/>Media</th>
                                            <th class="underline" lang="en" align="right">Délka</th>
                                            <th class="underline" lang="en" align="left">Časová<br/>značka</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <xsl:for-each select="SurveyChainList">
                                            <xsl:for-each select="SurveyChain">
                                                <tr>
                                                    <td align="left">
                                                        <xsl:value-of select="@name"/>
                                                    </td>
                                                    <td align="left">
                                                        <xsl:value-of select="@description"/>
                                                    </td>
                                                    <td align="left">
                                                        <xsl:value-of select="@code"/>
                                                    </td>
                                                    <td align="left">
                                                        <xsl:value-of select="@display"/>
                                                    </td>                                                    
                                                    <td align="right">
                                                        <xsl:value-of select="@zone"/>
                                                    </td>
                                                    <td align="left">
                                                        <xsl:value-of select="@attributesPair"/>
                                                    </td>
                                                    <td align="left">
                                                        <xsl:value-of select="@dataFileName"/>
                                                    </td>
                                                    <td align="left">
                                                        <xsl:value-of select="@fieldBook"/>
                                                    </td>
                                                    <td align="left">
                                                        <xsl:value-of select="@mediaFile"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                                                    </td>
                                                    <td align="left">
                                                        <xsl:value-of select="@timeStamp"/>
                                                    </td>
                                                </tr>
                                                <xsl:for-each select="VertexCourse">
                                                    <tr>
                                                        <!--<th align="left" nowrap="nowrap">Point: &#xa0;</th>-->
                                                          <th class="underline" lang="en" align="right" nowrap="nowrap"></th>

                                                          <th class="underline" lang="en" align="right" nowrap="nowrap">Vrchol</th>
                                                          <td class="underline" lang="en" align="left">
                                                              <xsl:value-of select="cif:directionFormat(number(@direction))"/>
                                                          </td>
                                                          
                                                          <th class="underline" lang="en" align="right" nowrap="nowrap">Vzdál: </th>
                                                          <td class="underline" lang="en" align="left">
                                                              <xsl:value-of select="cif:distanceFormat(number(@distance))"/>
                                                          </td>
                                                          <th class="underline" lang="en" align="right" nowrap="nowrap">Šikmá délka: </th>
                                                          <td class="underline" lang="en" align="left">
                                                              <xsl:value-of select="cif:distanceFormat(number(@slopeDistance))"/>
                                                          </td>
                                                          <th class="underline" lang="en" align="right" nowrap="nowrap">Rozdíl výšek: </th>
                                                          <td class="underline" lang="en" align="left">
                                                              <xsl:value-of select="cif:distanceFormat(number(@elevationDiff))"/>
                                                          </td>
                                                          <th class="underline" lang="en" align="right" nowrap="nowrap">Sklon: </th>
                                                          <td class="underline" lang="en" align="left">
                                                              <xsl:value-of select="cif:distanceFormat(number(@grade))"/>
                                                          </td>

                                                    </tr>
                                              </xsl:for-each>
                                              <xsl:for-each select="SurveyPoint">
                                                  <tr>
                                                      <!--<th align="left" nowrap="nowrap">Point: &#xa0;</th>-->
                                                      <th class="underline" lang="en" align="right" nowrap="nowrap">Bod:</th>
                                                      <td class="underline" lang="en" align="left">
                                                          <xsl:value-of select="@name"/>
                                                      </td>
                                                      <th class="underline" lang="en" align="right" nowrap="nowrap">Prvek: </th>
                                                      <td class="underline" lang="en" align="left">
                                                          <xsl:value-of select="@code"/>
                                                      </td>                                                              
                                                      <th class="underline" lang="en" align="right" nowrap="nowrap">Y </th>
                                                      <td class="underline" lang="en" align="left">
                                                          <xsl:value-of select="cif:distanceFormat(number(@Y))"/>
                                                      </td>           
                                                      <th class="underline" lang="en" align="right" nowrap="nowrap">X </th>
                                                      <td class="underline" lang="en" align="left">
                                                          <xsl:value-of select="cif:distanceFormat(number(@X))"/>
                                                      </td>     
                                                      <th class="underline" lang="en" align="right" nowrap="nowrap">Z </th>
                                                      <td class="underline" lang="en" align="left">
                                                          <xsl:value-of select="cif:distanceFormat(number(@Z))"/>
                                                      </td>  
                                                  </tr>
                                                  <!--<tr>
                                                      <th class="underline" lang="en" align="right" nowrap="nowrap">Zone: </th>
                                                      <td class="underline" lang="en" align="left">
                                                          <xsl:value-of select="@zone"/>
                                                      </td>                                                              
                                                      
                                                      <td align="left" nowrap="nowrap">
                                                          <xsl:value-of select="cif:directionFormat(number(@bearing))"/>
                                                      </td>                                                     
                                                  </tr>--> 
                                                  <xsl:for-each select="PointCourse">
                                                      <tr>
                                                          <!--<xsl:text>Course from: </xsl:text>
                                                          <xsl:value-of select="&#x9;@nameStart"/>-->
                                                          <th align="right" nowrap="nowrap"></th>
                                                          
                                                          <th align="right" nowrap="nowrap">&#xA;&#xA;Směr od: </th>
                                                          <td align="left">
                                                              <xsl:value-of select="@nameStart"/>
                                                          </td>
                                                          <th align="right" nowrap="nowrap"> do: </th>
                                                          <td align="left">
                                                              <xsl:value-of select="@nameEnd"/>
                                                          </td>
                                                          <th align="right" nowrap="nowrap"> </th>
                                                          <td align="left">
                                                              <xsl:value-of select="cif:directionFormat(number(@direction))"/>
                                                          </td>
                                                      </tr>
                                                      <tr>
                                                          <th class="underline" lang="en" align="right" nowrap="nowrap"></th>
                                                          
                                                          <th class="underline" lang="en" align="right" nowrap="nowrap">Vzdál: </th>
                                                          <td class="underline" lang="en" align="left">
                                                              <xsl:value-of select="cif:distanceFormat(number(@distance))"/>
                                                          </td>
                                                          <th class="underline" lang="en" align="right" nowrap="nowrap">Šikmá délka: </th>
                                                          <td class="underline" lang="en" align="left">
                                                              <xsl:value-of select="cif:distanceFormat(number(@slopeDistance))"/>
                                                          </td>
                                                          <th class="underline" lang="en" align="right" nowrap="nowrap">Rozdíl výšek: </th>
                                                          <td class="underline" lang="en" align="left">
                                                              <xsl:value-of select="cif:distanceFormat(number(@elevationDiff))"/>
                                                          </td>
                                                          <th class="underline" lang="en" align="right" nowrap="nowrap">Sklon: </th>
                                                          <td class="underline" lang="en" align="left">
                                                              <xsl:value-of select="cif:distanceFormat(number(@grade))"/>
                                                          </td>
                                                        
                                                      </tr>
                                                  </xsl:for-each>                                            
                                                </xsl:for-each>                                            
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                                    </xsl:for-each>
                                </xsl:for-each>
                       </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
             Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje minimálně jeden liniový prvek.</p>

<p class="normal1">FPro nejlepší výsledek spusťte výpis z panelu Detaily.   Vyberte Všechny liniové prvky v Průzkumníku projektu, které jsou v panelu Detaily.  Zvýrazněte řádky, které chcete mít ve výpisu, a pravým tlačítkem zvolte Výpis na vybraných položkách.
</p>
<p class="normal1">Spuštění výpisu z obecného nástroje výpisu zaměření nebo kliknutí pravým tlačítkem na grafický prvek provede výpis pouze na jednom vybraném prvku.</p>
            <p class="normal1">Po otevření Průzkumníku výpisů zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
